% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_and_split_abundance.R
\name{filter_and_split_abundance}
\alias{filter_and_split_abundance}
\title{Filter and Split Abundance Data by Threshold}
\usage{
filter_and_split_abundance(obj, threshold = 0.01, output_prefix = NULL)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{threshold}{A numeric value indicating the mean abundance threshold for filtering.}

\item{output_prefix}{A character string specifying the filename prefix for saving.
If \code{NULL}, files will not be saved. Default is \code{NULL}.}
}
\value{
A named list with components:
\describe{
\item{high}{Subset with taxa having mean abundance > threshold}
\item{low}{Subset with taxa having mean abundance <= threshold}
}
Each returned element contains a single object of the same class as the input (either \code{phyloseq} or \code{TreeSummarizedExperiment}).
}
\description{
Filters low-abundance taxa from a \code{phyloseq} or \code{TreeSummarizedExperiment} object,
splits data into high- and low-abundance groups, and optionally saves results.
}
\examples{
data("physeq_ITSOTU", package = "DspikeIn")

# Return results without saving
output <- filter_and_split_abundance(physeq_ITSOTU, threshold = 0.05)

# With saving
tse_ITSOTU <- convert_phyloseq_to_tse(physeq_ITSOTU)

output <- filter_and_split_abundance(tse_ITSOTU,
  threshold = 0.05,
  output_prefix = file.path(tempdir(), "abund")
)

}
