% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setParameters.R
\docType{methods}
\name{setParameters}
\alias{setParameters}
\alias{setParameters,ChemoProtSet-method}
\alias{setParameters,ANY,ANY-method}
\title{Method to set parameters for a ChemoProtSet}
\usage{
setParameters(x, chansVal, repsVal, dataTypeStr, modelTypeStr, PDBool = TRUE,
  removePepsBool = NA, incPDofPDBool = FALSE, PDofPDname = NA,
  incGeneFileBool = FALSE, organismStr = "h.sapiens", sigmoidConc = NA,
  pearsonThrshVal = 0.4)

\S4method{setParameters}{ChemoProtSet}(x, chansVal, repsVal, dataTypeStr,
  modelTypeStr, PDBool = TRUE, removePepsBool = NA, incPDofPDBool = FALSE,
  PDofPDname = NA, incGeneFileBool = FALSE, organismStr = "h.sapiens",
  sigmoidConc = NA, pearsonThrshVal = 0.4)
}
\arguments{
\item{x}{object of class 'ChemoProtSet'}

\item{chansVal}{number of channels / concentrations in experiment}

\item{repsVal}{number of replicates in experiment}

\item{dataTypeStr}{string describing the data type of input data set. This can be 'LFC' for log fold-changes, 'FC' for fold-changes and 'intensity' for peptide intensities}

\item{modelTypeStr}{string describing the type of model applied. This can be 'linear' for a linear model or 'sigmoid' for a sigmoidal model}

\item{PDBool}{boolean value indicating if the input data is from Proteome Discoverer 2.1 or not}

\item{removePepsBool}{boolean value indicating if peptide removal will take place. Only valid if input data is peptide intensities}

\item{incPDofPDBool}{boolean value indicating if the input data contais a pull-down of pull-down colum}

\item{PDofPDname}{string with the same name as colulmn containing pull-down of pull-down data. NA if this is not applicable}

\item{incGeneFileBool}{boolean value indicating if the data requires a protein accession to gene ID conversion file}

\item{organismStr}{string giving the name of organism. the options are: 'H.sapiens', 'D. melanogaster', 'C. elegans', 'R. norvegicus', 'M. musculus'. This is only needed if PDbool is FALSE}

\item{sigmoidConc}{vector of numerical values for concentrations of channels in the case of a sigmoidal fit}

\item{pearsonThrshVal}{numerial value between -1 and 1 which determines the cut-off used to discard peptides during peptide removal}
}
\value{
object of class ChemoProtSet
}
\description{
Give the ChemoProtSet object the correct parameters for a given experiment in order to successfully run the pipelin
}
\examples{
channelNames <- c('Abundance..F1..126..Control..REP_1',
'Abundance..F1..127..Sample..REP_1',  'Abundance..F1..128..Sample..REP_1',
'Abundance..F1..129..Sample..REP_1',  'Abundance..F1..130..Sample..REP_1',
'Abundance..F1..131..Sample..REP_1',  'Abundance..F2..126..Control..REP_2',
'Abundance..F2..127..Sample..REP_2', 'Abundance..F2..128..Sample..REP_2',
'Abundance..F2..129..Sample..REP_2',  'Abundance..F2..130..Sample..REP_2',
'Abundance..F2..131..Sample..REP_2')

ex <- new('ChemoProtSet')
ex<- setParameters(x = ex,chansVal = 6, repsVal = 2,dataTypeStr = 'intensity',
modelTypeStr = 'linear',PDBool = FALSE, removePepsBool = FALSE,
incPDofPDBool = FALSE, incGeneFileBool = FALSE,
organismStr = 'H.sapiens', pearsonThrshVal = 0.4)

ex
}
\seealso{
\code{\link{DoschedaSet}}
}
