% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dColorVector.R
\name{dColorVector}
\alias{dColorVector}
\title{Create a vector of colors of the same length as the data}
\usage{
dColorVector(x, colorOrder = unique(x), colorScale = "viridis")
}
\arguments{
\item{x}{Any vector.}

\item{colorOrder}{The order that the colors should be in in the output
vector. Defaults to the order that the unique values in x occurs.}

\item{colorScale}{The color scale. Inherited from the viridis, gplots and
grDevices packages (and the package-specific 'dark_rainbow'). Seven possible
scales are pre-made: inferno, magma, plasma, viridis, rich_colors, rainbow
and dark_rainbow. User specified vectors of colors
(e.g. c('#FF0033', '#03AF49')) are also accepted.}
}
\value{
A vector, the same length as x with each unique value substitutet
with a color.
}
\description{
This function takes a vector x and a shorter ordering vector with all the
unique values of the x vector in the specific order that the colors should be
in and returns a vector of RGB colors the same length as the initial x
vector.
}
\examples{
# Load some data
data(testData)

testColor <- dColorVector(testData$ids, colorScale = "plasma")

# In this case, each of the 97 individual donors in the dataset has gotten
# their own color code:
table(testColor)
}
\seealso{
\code{\link{dDensityPlot}}, \code{\link{dColorPlot}},
\code{\link{dViolins}}
}
