% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedDataFrame-class.R
\docType{class}
\name{DelayedDataFrame}
\alias{DelayedDataFrame}
\alias{.DelayedDataFrame}
\alias{DelayedDataFrame-class}
\alias{lazyIndex,DelayedDataFrame-method}
\alias{lazyIndex}
\alias{lazyIndex,DelayedDataFrame}
\alias{coerce}
\alias{.from_DataFrame_to_DelayedDataFrame}
\alias{coerce,DataFrame,DelayedDataFrame-method}
\alias{coerce,DFrame,DelayedDataFrame-method}
\alias{.from_DelayedDataFrame_to_DFrame}
\alias{coerce,DelayedDataFrame,DFrame-method}
\alias{coerce,DelayedDataFrame,DataFrame-method}
\alias{coerce,ANY,DelayedDataFrame-method}
\alias{lazyIndex<-}
\alias{lazyIndex<-,DelayedDataFrame-method}
\alias{"lazyIndex<-"}
\alias{"lazyIndex<-,}
\alias{DelayedDataFrame-class"}
\title{DelayedDataFrame-class}
\usage{
DelayedDataFrame(..., row.names = NULL, check.names = TRUE)

\S4method{lazyIndex}{DelayedDataFrame}(x)

.from_DataFrame_to_DelayedDataFrame(from)

.from_DelayedDataFrame_to_DFrame(from, to = "DFrame", strict = TRUE)

lazyIndex(x) <- value

\S4method{lazyIndex}{DelayedDataFrame}(x) <- value
}
\arguments{
\item{...}{the arguments to pass into construction of a new
\code{DelayedDataFrame}.}

\item{row.names}{the \code{rownames} for the newly constructed
\code{DelayedDataFrame} object.}

\item{check.names}{logical.  If ‘TRUE’ then the names of the
variables in the \code{DelayedDataFrame} are checked to ensure
that they are syntactically valid variable names and are not
duplicated.  If necessary they are adjusted (by ‘make.names’)
so that they are.}

\item{x}{the \code{DelayedDataFrame} object.}

\item{from}{the object to be converted.}

\item{to}{the class of object to be returned by coercion.}

\item{strict}{Logical. Whether to force return a \code{DataFrame}.}

\item{value}{the new value of \code{lazyIndex} slot for
\code{DelayedDataFrame} object.}
}
\value{
\code{lazyIndex<-}: the \code{DelayedDataFrame} object with
    new value of \code{lazyIndex} slot.
}
\description{
The \code{DelayedDataFrame} class extends the
    \code{DataFrame} class and supports the storage of any type of
    object (with ‘length’ and ‘[’ methods) as columns.

the \code{lazyIndex} slot getter and setter for
    \code{DelayedDataFrame} object.

the coercion method between \code{DataFrame} and
    \code{DelayedDataFrame} objects.
}
\details{
The \code{DelayedDataFrame} inherits from \code{DataFrame}
    and behaves very similarily in terms of construction,
    subsetting, splitting, combining, etc. The most notable
    exception is that The additional slot of \code{lazyIndex},
    enables \code{DelayedArray} (with different back-ends) columns
    to share indexes when possible.

Please be very careful to use this replace method for
    \code{lazyIndex} slot. Because it only replace the
    \code{lazyIndex} slot, but not necessarily the \code{nrow} and
    \code{rownames} slots. If you want to have synchronized
    subsetting for all slots, the \code{[} method should be used.
}
\examples{
DDF <- DelayedDataFrame(letters, LETTERS)
DDF1 <- DDF[1:10,]
DDF1
lazyIndex(DDF1)
as(DDF1, "DataFrame")

}
