% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marker_express_ALL.R
\name{plot_marker_express_ALL}
\alias{plot_marker_express_ALL}
\title{Plot the top marker genes for ALL cell types}
\usage{
plot_marker_express_ALL(
  sce,
  stats,
  pdf_fn = NULL,
  n_genes = 10,
  rank_col = "MeanRatio.rank",
  anno_col = "MeanRatio.anno",
  gene_col = "gene",
  cellType_col = "cellType",
  color_pal = NULL,
  plot_points = FALSE
)
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class} object}

\item{stats}{A \code{data.frame()} generated by \code{get_mean_ratio()} and/or
\code{findMarkers_1vAll()}.}

\item{pdf_fn}{A \code{character()} of the pdf filename to plot to, if \code{NULL} returns all plots}

\item{n_genes}{An \code{integer(1)} of number of markers you'd like to plot}

\item{rank_col}{The \code{character(1)} name of column to rank genes by in
\code{stats}.}

\item{anno_col}{The \code{character(1)} name of column containing annotation in
\code{stats}.}

\item{gene_col}{The \code{character(1)} name of column containing gene name in
\code{stats} should be the same syntax as \code{rownames(sce)}.}

\item{cellType_col}{The \code{character(1)} name of \code{colData()} column containing
cell type for \code{sce} data. It should match \code{cellType.target} in \code{stats}.}

\item{color_pal}{A named \code{character(1)} vector that contains a color palette
matching the \code{cell_type} values.}

\item{plot_points}{A \code{logical(1)} indicating whether to plot points over the
violin, defaults to \code{FALSE} as these often become over plotted and quite
large (especially when saved as PDF).}
}
\value{
A PDF file with violin plots for the expression of top marker genes
for all cell types.
}
\description{
This function plots the top n marker genes for a all cell types based off of
the \code{stats} table from \code{get_mean_ratio()} in a multi-page PDF file.
The gene expression is plotted as violin plot with \code{plot_gene_express()} and
adds annotations to each plot.
}
\examples{
#' ## Fetch sce example data
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")

## load example marker stats
data("marker_test")

# Plot marker gene expression to PDF, one page per cell type in stats
pdf_file <- tempfile("test_marker_expression_ALL", fileext = ".pdf")

plot_marker_express_ALL(
    sce_DLPFC_example,
    cellType_col = "cellType_broad_hc",
    stat = marker_test,
    pdf_fn = pdf_file
)

if (interactive()) browseURL(pdf_file)
}
\seealso{
Other expression plotting functions: 
\code{\link{plot_gene_express}()},
\code{\link{plot_marker_express}()},
\code{\link{plot_marker_express_List}()}
}
\concept{expression plotting functions}
