% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qc.R
\name{plotCountsInPeaks}
\alias{plotCountsInPeaks}
\title{Plotting the}
\usage{
plotCountsInPeaks(
  counts.df,
  dm_results.df,
  peaks.df,
  position = c("stack", "fill")
)
}
\arguments{
\item{counts.df}{A counts data.frame as outputted from `countBamInGatc`}

\item{dm_results.df}{A data.frame of differential testing results as outputted from `testDmRegions()`.}

\item{peaks.df}{A data.frame of peaks as outputted from `identifyPeaks()`.}

\item{position}{If the bar plots should be stacked (showing the count), or fill (showing proportion). Default is "stack".}
}
\value{
A ggplot2 bar plot
}
\description{
Plotting the
}
\examples{
set.seed(123)
counts.df <- random_counts()[1:2,]
dm_results <- random_edgeR_results()[1:2,]
peaks <- identifyPeaks(dm_results)

# stacked plot
plotCountsInPeaks(counts.df, dm_results, peaks, position = "stack")
# filled plot
plotCountsInPeaks(counts.df, dm_results, peaks, position = "fill")
}
