% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Feature_Selection.R
\name{DaMiR.FReduct}
\alias{DaMiR.FReduct}
\title{Remove highly correlated features, based on feature-per-feature
 correlation.}
\usage{
DaMiR.FReduct(data, th.corr = 0.85, type = c("spearman", "pearson"))
}
\arguments{
\item{data}{A transposed data frame or matrix of normalized expression
data. Rows and Cols should be,
respectively, observations and features}

\item{th.corr}{Feature-per-feature correlation threshold; default is
0.85}

\item{type}{Type of correlation metric to be applied; default is
"spearman"}
}
\value{
An expression matrix without highly correlated features.
}
\description{
This function allows the user to remove highly correlated
 features.
}
\details{
This function produces an absolute correlation matrix that
it is then used to reduce pair-wise correlations.
When two features present a correlation higher than that defined by
the user in \code{th.corr} argument,
the function, first, calculates the mean absolute correlation of each
 feature and, then, removes the feature
with the largest mean absolute correlation.
}
\examples{
# use example data:
data(data_reduced)
# reduce the number of features:
data_Reduced <- DaMiR.FReduct(data_reduced,
th.corr = 0.75, type = "pearson")

}
\seealso{
\code{\link{rcorr}}, \code{\link{findCorrelation}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
