% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichDO.R
\name{enrichDO}
\alias{enrichDO}
\title{DO Enrichment Analysis}
\usage{
enrichDO(
  gene,
  ont = "HDO",
  organism = "hsa",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  readable = FALSE
)
}
\arguments{
\item{gene}{a vector of entrez gene id}

\item{ont}{one of "HDO", "HPO" or "MPO".}

\item{organism}{one of "hsa" and "mmu"}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{minGSSize}{minimal size of genes annotated by NCG category for testing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{qvalueCutoff}{qvalue cutoff}

\item{readable}{whether mapping gene ID to gene Name}
}
\value{
A \code{enrichResult} instance.
}
\description{
Given a vector of genes, this function will return the enrichment DO
categories with FDR control.
}
\examples{

data(geneList)
	gene = names(geneList)[geneList > 1]
	yy = enrichDO(gene, pvalueCutoff=0.05)
	summary(yy)

}
\seealso{
\code{\link{enrichResult-class}}
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
\keyword{manip}
