% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{poolMethylationDatasets}
\alias{poolMethylationDatasets}
\title{Pool methylation data}
\usage{
poolMethylationDatasets(methylationDataList)
}
\arguments{
\item{methylationDataList}{a \code{\link{GRangesList}} object where each
element of the list is a \code{\link{GRanges}} object with the methylation
data in the corresponding condition (see \code{\link{methylationDataList}}).}
}
\value{
the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).
If the Granges are from ONT datasets, its have six metedata columns include as
ONT_Cm and ONT_C (see \code{\link{readONTbam}}).
}
\description{
This function pools together multiple methylation datasets.
}
\examples{
# load methylation data object
data(methylationDataList)

# pools the two datasets together
pooledMethylationData <- poolMethylationDatasets(methylationDataList)

}
\author{
Nicolae Radu Zabet updated by Young Jun Kim
}
