% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toBED.R
\name{toBED}
\alias{toBED}
\title{windows/regions to BED}
\usage{
toBED(
  windowRes,
  regionRes,
  fileName,
  padjCol = "padj",
  padjThresh = 0.05,
  log2FoldChangeCol = "log2FoldChange",
  log2FoldChangeThresh = 1,
  trackName = "sliding windows",
  description = "sliding windows"
)
}
\arguments{
\item{windowRes}{\code{data.frame}, output from \code{\link{resultsDEWSeq}}}

\item{regionRes}{\code{data.frame}, output from \code{\link{extractRegions}}}

\item{fileName}{\code{character}, filename to save BED output}

\item{padjCol}{\code{character}, name of the adjusted pvalue column (default: padj)}

\item{padjThresh}{\code{numeric}, threshold for p-adjusted value (default: 0.05)}

\item{log2FoldChangeCol}{\code{character}, name of the log2foldchange column (default: log2FoldChange)}

\item{log2FoldChangeThresh}{\code{numeric}, threshold for log2foldchange value (default:1)}

\item{trackName}{\code{character}, name of this track, for visualization}

\item{description}{\code{character}, description of this track, for visualization}
}
\value{
write to file
}
\description{
given output of \code{\link{extractRegions}}, \code{\link{resultsDEWSeq}} and significance thresholds,
extract significant windows, create regions by merging adjacent significant windows.
Finally, write the output as a BED file for visualization.
}
\examples{

data(slbpRegions)
data(slbpWindows)
outFile <- tempfile('SLBP_visualization.bed')
# the results are written to a temp file in this example
toBED(slbpWindows,slbpRegions,outFile,padjCol='pSlidingWindows.adj')

}
