% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{RleListToRleMatrix}
\alias{RleListToRleMatrix}
\title{RleListToRleMatrix}
\usage{
RleListToRleMatrix(RleList, dimnames = NULL)
}
\arguments{
\item{RleList}{an RleList object with all elements of the same length.}

\item{dimnames}{the names for dimensions of RleMatrix (see DelayedArray pkg).}
}
\value{
a RleMatrix from DelayedArray package.
}
\description{
a wrapper to create a RleMatrix from a RleList object.
}
\examples{
library("DelayedArray")
lengths <-  c(3, 1, 2)
values <- c(15, 5, 20)
el1 <- S4Vectors::Rle(values=values, lengths=lengths)

el2 <- S4Vectors::Rle(values=sort(values), lengths=lengths)

rleList <- IRanges::RleList(el1, el2)
names(rleList) <- c("one", "two")
(rleMat <- RleListToRleMatrix(rleList))
}
