% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_QC.R
\name{plot_normalization}
\alias{plot_normalization}
\title{Visualize normalization}
\usage{
plot_normalization(se, ...)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object, e.g. before normalization (output from \code{\link{make_se}()}
or \code{\link{make_se_parse}()}).}

\item{...}{Additional SummarizedExperiment object(s),
E.g. data object after normalization
(output from \code{\link{normalize_vsn}}).}
}
\value{
Boxplots of all conditions
for input objects, e.g. before and after normalization
  (generated by \code{\link[ggplot2]{ggplot}}).
Adding components and other plot adjustments can be easily done
using the ggplot2 syntax (i.e. using '+')
}
\description{
\code{plot_normalization} generates boxplots
of all conditions for input objects, e.g. before and after normalization.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and normalize
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)

# Plot normalization
plot_normalization(se, filt, norm)
}
