% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_QC.R
\name{plot_imputation}
\alias{plot_imputation}
\title{Visualize imputation}
\usage{
plot_imputation(se, ...)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object, e.g. before imputation
(output from \code{\link{normalize_vsn}()}).}

\item{...}{Other SummarizedExperiment object(s),
E.g. data object after imputation
(output from \code{\link{impute}()}).}
}
\value{
Density plots of all conditions
of all conditions for input objects, e.g. before and
after imputation (generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_imputation} generates density plots
of all conditions for input objects, e.g. before and after imputation.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Plot imputation
plot_imputation(filt, norm, imputed)
}
