% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_explore.R
\name{plot_cor}
\alias{plot_cor}
\title{Plot correlation matrix}
\usage{
plot_cor(
  dep,
  significant = TRUE,
  lower = -1,
  upper = 1,
  pal = "PRGn",
  pal_rev = FALSE,
  indicate = NULL,
  font_size = 12,
  plot = TRUE,
  ...
)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}

\item{significant}{Logical(1),
Whether or not to filter for significant proteins.}

\item{lower}{Integer(1),
Sets the lower limit of the color scale.}

\item{upper}{Integer(1),
Sets the upper limit of the color scale.}

\item{pal}{Character(1),
Sets the color panel (from \pkg{RColorBrewer}).}

\item{pal_rev}{Logical(1),
Whether or not to invert the color palette.}

\item{indicate}{Character,
Sets additional annotation on the top of the heatmap
based on columns from the experimental design (colData).}

\item{font_size}{Integer(1),
Sets the size of the labels.}

\item{plot}{Logical(1),
If \code{TRUE} (default) the correlation matrix plot is produced.
Otherwise (if \code{FALSE}), the data which the
correlation matrix plot is based on are returned.}

\item{...}{Additional arguments for Heatmap function as depicted in
\code{\link[ComplexHeatmap]{Heatmap}}}
}
\value{
A heatmap plot (generated by \code{\link[ComplexHeatmap]{Heatmap}})
}
\description{
\code{plot_cor} generates a Pearson correlation matrix.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Plot correlation matrix
plot_cor(dep)
}
