% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_se_parse}
\alias{make_se_parse}
\title{Data.frame to SummarizedExperiment object
conversion using parsing from column names}
\usage{
make_se_parse(
  proteins_unique,
  columns,
  mode = c("char", "delim"),
  chars = 1,
  sep = "_"
)
}
\arguments{
\item{proteins_unique}{Data.frame,
Protein table with unique names annotated in the 'name' column
(output from \code{\link{make_unique}()}).}

\item{columns}{Integer vector,
Column numbers indicating the columns containing the assay data.}

\item{mode}{"char" or "delim",
The mode of parsing the column headers.
"char" will parse the last number of characters as replicate number
and requires the 'chars' parameter.
"delim" will parse on the separator and requires the 'sep' parameter.}

\item{chars}{Numeric(1),
The number of characters to take at the end of the column headers
as replicate number (only for mode == "char").}

\item{sep}{Character(1),
The separator used to parse the column header
(only for mode == "delim").}
}
\value{
A SummarizedExperiment object
with log2-transformed values.
}
\description{
\code{make_se_parse} creates a SummarizedExperiment object
based on a single data.frame.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
se <- make_se_parse(data_unique, columns, mode = "char", chars = 1)
se <- make_se_parse(data_unique, columns, mode = "delim", sep = "_")
}
