% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{import_MaxQuant}
\alias{import_MaxQuant}
\title{Import from MaxQuant}
\usage{
import_MaxQuant(
  proteins,
  expdesign,
  filter = c("Reverse", "Potential.contaminant"),
  intensities = "LFQ",
  names = "Gene.names",
  ids = "Protein.IDs",
  delim = ";"
)
}
\arguments{
\item{proteins}{Data.frame,
Protein table originating from MaxQuant.}

\item{expdesign}{Data.frame,
Experimental design with 'label', 'condition'
and 'replicate' information.
See \code{\link{UbiLength_ExpDesign}} for an example experimental design.}

\item{filter}{Character,
Name of the column(s) containing features to be filtered on.}

\item{intensities}{Character(1),
Prefix of the columns containing sample intensities.}

\item{names}{Character(1),
Name of the column containing feature names.}

\item{ids}{Character(1),
Name of the column containing feature IDs.}

\item{delim}{Character(1),
Sets the delimiter separating the feature names within on protein group.}
}
\value{
A SummarizedExperiment object with log2-transformed values and
"name" and "ID" columns containing unique names and identifiers.
}
\description{
\code{import_MaxQuant} imports a protein table from MaxQuant
and converts it into a SummarizedExperiment object.
}
\examples{
# Load example data and experimental design
data <- UbiLength
exp_design <- UbiLength_ExpDesign

# Import data
se <- import_MaxQuant(data, exp_design)
}
