% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{filter_proteins}
\alias{filter_proteins}
\title{Filter proteins based on missing values}
\usage{
filter_proteins(
  se,
  type = c("complete", "condition", "fraction"),
  thr = NULL,
  min = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}).}

\item{type}{"complete", "condition" or "fraction",
Sets the type of filtering applied. "complete" will only keep
proteins with valid values in all samples. "condition" will keep
proteins that have a maximum of 'thr' missing values in at least
one condition. "fraction" will keep proteins that have a certain
fraction of valid values in all samples.}

\item{thr}{Integer(1),
Sets the threshold for the allowed number of missing values
in at least one condition if type = "condition".}

\item{min}{Numeric(1),
Sets the threshold for the minimum fraction of valid values
allowed for any protein if type = "fraction".}
}
\value{
A filtered SummarizedExperiment object.
}
\description{
\code{filter_proteins} filters a proteomic dataset based on missing values.
Different types of filtering can be applied, which range from only keeping
proteins without missing values to keeping proteins with a certain percent
valid values in all samples or keeping proteins that are complete
in at least one condition.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter
stringent_filter <- filter_proteins(se, type = "complete")
less_stringent_filter <- filter_proteins(se, type = "condition", thr = 0)
}
