% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{filter_missval}
\alias{filter_missval}
\title{Filter on missing values}
\usage{
filter_missval(se, thr = 0)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}).}

\item{thr}{Integer(1),
Sets the threshold for the allowed number of missing values
in at least one condition.}
}
\value{
A filtered SummarizedExperiment object.
}
\description{
\code{filter_missval} filters a proteomics dataset based on missing values.
The dataset is filtered for proteins that have a maximum of
'thr' missing values in at least one condition.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter
stringent_filter <- filter_missval(se, thr = 0)
less_stringent_filter <- filter_missval(se, thr = 1)
}
