% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inOutFiles.R
\name{writeMSnsetToExcel}
\alias{writeMSnsetToExcel}
\title{This function exports a \code{MSnSet} object to a Excel file.}
\usage{
writeMSnsetToExcel(obj, filename)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{filename}{A character string for the name of the Excel file.}
}
\value{
A Excel file (.xlsx)
}
\description{
This function exports a \code{MSnSet} data object to a Excel file.
Each of the three data.frames in the \code{MSnSet} object (ie experimental
data, phenoData and metaData are respectively integrated into separate sheets
in the Excel file). 

The colored cells in the experimental data correspond to the original
missing values which have been imputed.
}
\examples{
Sys.setenv("R_ZIPCMD" = Sys.which("zip"))
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10)]
writeMSnsetToExcel(obj, "foo")


}
\author{
Samuel Wieczorek
}
