% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{wrapper.normalizeD}
\alias{wrapper.normalizeD}
\title{Normalisation}
\usage{
wrapper.normalizeD(obj, method, withTracking = FALSE, ...)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{method}{One of the following : "GlobalQuantileAlignment" (for
normalizations of important magnitude), "SumByColumns", "QuantileCentering",
"Mean Centering", "LOESS" and "vsn".}

\item{withTracking}{xxx}

\item{...}{xxx}
}
\value{
xxx
}
\description{
Provides several methods to normalize quantitative data from
a \code{MSnSet} object.
They are organized in six main families : GlobalQuantileAlignement,
sumByColumns, QuantileCentering, MeanCentering, LOESS, vsn
For the first family, there is no type.
For the five other families, two type categories are available :
"Overall" which means that the value for each protein
(ie line in the expression data tab) is computed over all the samples ;
"within conditions" which means that the value for each protein
(ie line in the \code{Biobase::exprs()} data tab) is computed condition
by condition.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
conds <- Biobase::pData(Exp1_R25_pept)$Condition
obj <- wrapper.normalizeD(
    obj = Exp1_R25_pept, method = "QuantileCentering",
    conds = conds, type = "within conditions"
)

}
\author{
Samuel Wieczorek, Thomas Burger, Helene Borges
}
