% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{wrapper.impute.slsa}
\alias{wrapper.impute.slsa}
\title{Imputation of peptides having no values in a biological condition.}
\usage{
wrapper.impute.slsa(obj = NULL)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}
}
\value{
The \code{Biobase::exprs(obj)} matrix with imputed values 
instead of missing values.
}
\description{
This method is a wrapper to the function \code{impute.slsa()} of the package
\code{imp4p} adapted to an object of class \code{MSnSet}.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(100)]
obj.slsa.pov <- wrapper.impute.slsa(obj)

}
\author{
Samuel Wieczorek
}
