% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{wrapper.impute.pa}
\alias{wrapper.impute.pa}
\title{Imputation of peptides having no values in a biological condition.}
\usage{
wrapper.impute.pa(obj = NULL, q.min = 0.025)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{q.min}{Same as the function \code{impute.pa()} in the package
\code{imp4p}}
}
\value{
The \code{Biobase::exprs(obj)} matrix with imputed values instead of
missing values.
}
\description{
This method is a wrapper to the function \code{impute.pa} of the package
\code{imp4p} adapted to an object of class \code{MSnSet}.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(10)]
obj.imp.pov <- wrapper.impute.pa(obj)

}
\author{
Samuel Wieczorek
}
