% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nonzero}
\alias{nonzero}
\title{Retrieve the indices of non-zero elements in sparse matrices}
\usage{
nonzero(x)
}
\arguments{
\item{x}{A sparse matrix of class dgCMatrix}
}
\value{
A two-column matrix
}
\description{
This function retrieves the indices of non-zero elements in sparse matrices
of class dgCMatrix from package Matrix. This function is largely inspired
from the package \code{RINGO}
}
\examples{
library(Matrix)
mat <- Matrix(c(0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1),
    nrow = 5, byrow = TRUE,
    sparse = TRUE
)
res <- nonzero(mat)

}
\author{
Samuel Wieczorek
}
