% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell_Plots.R
\name{metacellPerLinesHistoPerCondition_HC}
\alias{metacellPerLinesHistoPerCondition_HC}
\title{Bar plot of missing values per lines and per condition}
\usage{
metacellPerLinesHistoPerCondition_HC(
  obj,
  pattern = NULL,
  indLegend = "auto",
  showValues = FALSE,
  pal = NULL
)
}
\arguments{
\item{obj}{xxx}

\item{pattern}{xxx}

\item{indLegend}{The indice of the column name's in \code{Biobase::pData()} 
tab}

\item{showValues}{A logical that indicates wether numeric values should be
drawn above the bars.}

\item{pal}{xxx}
}
\value{
A bar plot
}
\description{
This method plots a bar plot which represents the distribution of the
number of missing values (NA) per lines (ie proteins) and per conditions.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept
pal <- ExtendPalette(length(unique(Biobase::pData(obj)$Condition)), "Dark2")
metacellPerLinesHistoPerCondition_HC(obj, c("Missing POV", "Missing MEC"), pal = pal)
metacellPerLinesHistoPerCondition_HC(obj, "Quantified")

}
\author{
Samuel Wieczorek
}
