% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffAnalysis.R
\name{histPValue_HC}
\alias{histPValue_HC}
\title{Plots a histogram ov p-values}
\usage{
histPValue_HC(pval_ll, bins = 80, pi0 = 1)
}
\arguments{
\item{pval_ll}{xxx}

\item{bins}{xxx}

\item{pi0}{xxx}
}
\value{
A plot
}
\description{
Plots a histogram ov p-values
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
allComp <- limmaCompleteTest(qData, sTab)
histPValue_HC(allComp$P_Value[1])

}
\author{
Samuel Wieczorek
}
