% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{getProteinsStats}
\alias{getProteinsStats}
\title{Computes the number of proteins that are only defined by
specific peptides, shared peptides or a mixture of two.}
\usage{
getProteinsStats(matShared)
}
\arguments{
\item{matShared}{The adjacency matrix with both specific and
shared peptides.}
}
\value{
A list
}
\description{
This function computes the number of proteins that are only defined by
specific peptides, shared peptides or a mixture of two.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
protID <- "Protein_group_IDs"
obj <- Exp1_R25_pept[seq_len(20)]
MShared <- BuildAdjacencyMatrix(obj, protID, FALSE)
getProteinsStats(matShared = MShared)

}
\author{
Samuel Wieczorek
}
