% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioAnalysis.R
\name{barplotGroupGO_HC}
\alias{barplotGroupGO_HC}
\title{A barplot which shows the result of a GO classification, using the
package \code{highcharter}}
\usage{
barplotGroupGO_HC(ggo, maxRes = 5, title = "")
}
\arguments{
\item{ggo}{The result of the GO classification, provides either by the
function \code{group_GO} in the package \code{DAPAR} or the function
\code{groupGO} in the package `clusterProfiler`}

\item{maxRes}{An integer which is the maximum number of classes to display
in the plot}

\item{title}{The title of the plot}
}
\value{
A barplot
}
\description{
A barplot which shows the result of a GO classification, using the
package \code{highcharter}
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(10)]
if (!requireNamespace("org.Sc.sgd.db", quietly = TRUE)) {
stop("Please install org.Sc.sgd.db: 
            BiocManager::install('org.Sc.sgd.db')")
}
library(org.Sc.sgd.db)
univ <- univ_AnnotDbPkg("org.Sc.sgd.db")
ggo <- group_GO(
    data = Biobase::fData(obj)$Protein.IDs, idFrom = "UNIPROT",
    orgdb = "org.Sc.sgd.db", ont = "MF", level = 2
)
barplotGroupGO_HC(ggo)

}
\author{
Samuel Wieczorek
}
