% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{SumByColumns}
\alias{SumByColumns}
\title{Normalisation SumByColumns}
\usage{
SumByColumns(qData, conds = NULL, type = NULL, subset.norm = NULL)
}
\arguments{
\item{qData}{xxxx}

\item{conds}{xxx}

\item{type}{Available values are "overall" (shift all the
sample distributions at once) or "within conditions" (shift the sample
distributions within each condition at a time).}

\item{subset.norm}{A vector of index indicating rows to be used for
normalization}
}
\value{
A normalized numeric matrix
}
\description{
Normalisation SumByColumns
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
qData <- Biobase::exprs(Exp1_R25_pept)
conds <- Biobase::pData(Exp1_R25_pept)$Condition
normalized <- SumByColumns(qData, conds,
    type = "within conditions",
    subset.norm = seq_len(10)
)

}
\author{
Samuel Wieczorek, Thomas Burger, Helene Borges, Anais Courtier,
Enora Fremy
}
