% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell.R
\name{Metacell_generic}
\alias{Metacell_generic}
\title{Sets the metacell dataframe for dataset without information about the
origin of identification}
\usage{
Metacell_generic(qdata, conds, level)
}
\arguments{
\item{qdata}{An object of class \code{MSnSet}}

\item{conds}{xxx}

\item{level}{xxx}
}
\value{
xxxxx
}
\description{
In the quantitative columns, a missing value is identified by no value rather
than a value equal to 0.
Conversion rules
QuantiTag
NA or 0 NA
The only information detected with this function are about missing values (
MEC and POV).
}
\examples{
file <- system.file("extdata", "Exp1_R25_pept.txt", package = "DAPARdata")
data <- read.table(file, header = TRUE, sep = "\t", stringsAsFactors = FALSE)
metadataFile <- system.file("extdata", "samples_Exp1_R25.txt",
    package = "DAPARdata"
)
metadata <- read.table(metadataFile,
    header = TRUE, sep = "\t", as.is = TRUE,
    stringsAsFactors = FALSE
)
conds <- metadata$Condition
qdata <- data[seq_len(100), seq.int(from = 56, to = 61)]
df <- data[seq_len(100), seq.int(from = 43, to = 48)]
df <- Metacell_generic(qdata, conds, level = "peptide")

}
\author{
Samuel Wieczorek
}
