% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{LOESS}
\alias{LOESS}
\title{Normalisation LOESS}
\usage{
LOESS(qData, conds, type = "overall", span = 0.7)
}
\arguments{
\item{qData}{A numeric matrix.}

\item{conds}{xxx}

\item{type}{"overall" (shift all the sample distributions at once) or
"within conditions" (shift the sample distributions within each
condition at a time).}

\item{span}{xxx}
}
\value{
A normalized numeric matrix
}
\description{
Normalisation LOESS
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
qData <- Biobase::exprs(Exp1_R25_pept)
conds <- Biobase::pData(Exp1_R25_pept)$Condition
normalized <- LOESS(qData, conds, type = "overall")

}
\author{
Thomas Burger, Helene Borges, Anais Courtier, Enora Fremy
}
