% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesFilter.R
\name{GetIndices_BasedOnConditions}
\alias{GetIndices_BasedOnConditions}
\title{Search lines which respects request on one or more conditions.}
\usage{
GetIndices_BasedOnConditions(metacell.mask, type, conds, percent, op, th)
}
\arguments{
\item{metacell.mask}{xxx}

\item{type}{Available values are:
* 'AllCond' (the query is valid in all the conditions),
* 'AtLeatOneCond' (the query is valid in at leat one condition.}

\item{conds}{xxx}

\item{percent}{xxx}

\item{op}{String for operator to use. List of operators is available 
with SymFilteringOperators().}

\item{th}{The theshold to apply}
}
\value{
xxx
}
\description{
This function looks for the lines that respect the request in either 
all conditions
or at least one condition.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10)]
level <- GetTypeofData(obj)
pattern <- 'Missing'
metacell.mask <- match.metacell(metadata=GetMetacell(obj), 
pattern=pattern, level=level)
type <- 'AllCond'
conds <- Biobase::pData(obj)$Condition
op <- '>='
th <- 0.5
percent <- TRUE
ind <- GetIndices_BasedOnConditions(metacell.mask, type, conds, 
percent, op, th)

}
