% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agregation.R
\name{GetDetailedNbPeptidesUsed}
\alias{GetDetailedNbPeptidesUsed}
\title{Computes the detailed number of peptides used for aggregating
each protein}
\usage{
GetDetailedNbPeptidesUsed(X, qdata.pep)
}
\arguments{
\item{X}{An adjacency matrix}

\item{qdata.pep}{A data.frame of quantitative data}
}
\value{
A list of two items
}
\description{
Method to compute the detailed number of quantified peptides used for
aggregating each protein
}
\examples{
NULL

}
\author{
Samuel Wieczorek
library(MSnbase)
data(Exp1_R25_pept, package="DAPARdata")
protID <- "Protein_group_IDs"
X <- BuildAdjacencyMatrix(Exp1_R25_pept[seq_len(10)], protID, FALSE)
ll.n <- GetDetailedNbPeptidesUsed(X, 
Biobase::exprs(Exp1_R25_pept[seq_len(10)]))
}
