% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{ExtendPalette}
\alias{ExtendPalette}
\title{Extends a base-palette of the package RColorBrewer to n colors.}
\usage{
ExtendPalette(n = NULL, base = "Set1")
}
\arguments{
\item{n}{The number of desired colors in the palette}

\item{base}{The name of the palette of the package RColorBrewer from which
the extended palette is built. Default value is 'Set1'.}
}
\value{
A vector composed of n color code.
}
\description{
The colors in the returned palette are always in the same order
}
\examples{
ExtendPalette(12)
nPalette <- 10
par(mfrow = c(nPalette, 1))
par(mar = c(0.5, 4.5, 0.5, 0.5))
for (i in seq_len(nPalette)) {
    pal <- ExtendPalette(n = i, base = "Dark2")
    barplot(seq_len(length(pal)), col = pal)
    print(pal)
}

}
\author{
Samuel Wieczorek
}
