% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoPipeline-functions.R
\name{exportCytoPipeline}
\alias{exportCytoPipeline}
\alias{export2JSONFile}
\title{exporting CytoPipeline objects}
\usage{
export2JSONFile(x, path)
}
\arguments{
\item{x}{a CytoPipeline object}

\item{path}{the full path to the name of the file to be created}
}
\value{
\itemize{
\item for \code{export2JSONFile}: nothing
}
}
\description{
functions to export CytoPipeline objects in various
formats
}
\section{Functions}{
\itemize{
\item \code{export2JSONFile()}: exports a CytoPipeline object
to a JSON file (writing the file = side effect)

}}
\examples{

outputDir <- base::tempdir()

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
experimentName <- "OMIP021_PeacoQC"
sampleFiles <- file.path(rawDataDir, list.files(rawDataDir,
                                             pattern = "Donor"))

# build CytoPipeline object using json input
jsonPath <- file.path(system.file("extdata", package = "CytoPipeline"), 
                      "pipelineParams.json")
  
pipL <- CytoPipeline(jsonPath,
                     experimentName = experimentName,
                     sampleFiles = sampleFiles)

# remove the last pre-processing step
nPreProcessing <- getNbProcessingSteps(pipL, whichQueue = "pre-processing")
pipL <- removeProcessingStep(pipL, whichQueue = "pre-processing", 
                                   index = nPreProcessing)

# export back to json file    
export2JSONFile(pipL, path = file.path(outputDir, "newFile.json")) 
}
