% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFreqHeatmap.R
\name{plotFreqHeatmap}
\alias{plotFreqHeatmap}
\alias{plotFreqHeatmap,matrix-method}
\alias{plotFreqHeatmap,CrisprSet-method}
\title{Plot a table of counts with colours indicating frequency}
\usage{
plotFreqHeatmap(obj, ...)

\S4method{plotFreqHeatmap}{matrix}(
  obj,
  ...,
  col.sums = NULL,
  header = NA,
  header.name = "Total",
  group = NULL,
  group.colours = NULL,
  as.percent = TRUE,
  x.axis.title = NULL,
  x.size = 6,
  y.size = 8,
  x.angle = 90,
  legend.text.size = 6,
  plot.text.size = 3,
  line.width = 1,
  x.hjust = 1,
  legend.position = "right",
  x.labels = NULL,
  legend.key.height = grid::unit(1, "lines")
)

\S4method{plotFreqHeatmap}{CrisprSet}(
  obj,
  ...,
  top.n = 50,
  min.freq = 0,
  min.count = 1,
  type = c("counts", "proportions"),
  order = NULL,
  alleles = NULL
)
}
\arguments{
\item{obj}{A matrix of counts with rows = feature, columns = sample}

\item{...}{additional arguments}

\item{col.sums}{Alternative column sums to be used for calculating
the tile colours if as.percent = TRUE, e.g. if "obj" is a subset of
a larger data set.  If "NULL" (default), the column sums of "obj" are used.}

\item{header}{Alternative column titles, e.g. column sums for the
unfiltered data set when obj is a subset.  If set to "NA", column sums
of obj are displayed. If "NULL", no header is displayed (Default: NA).}

\item{header.name}{Label for the header row (Default: "Total")}

\item{group}{Grouping factor for columns.  If supplied, columns are
ordered to match the levels  (Default: NULL)}

\item{group.colours}{Colours for column groups, should match levels of "group".
If "NULL", groups are coloured differently (Default: NULL)}

\item{as.percent}{Should colours represent the percentage of reads
per sample (TRUE) or the actual counts (FALSE)?  (Default: TRUE)}

\item{x.axis.title}{A title for the x-axis.  (Default: NULL)}

\item{x.size}{Font size for x-labels (Default: 16)}

\item{y.size}{Font size for y-labels (Default: 16)}

\item{x.angle}{Angle for x-labels (Default: 90, i.e. vertical)}

\item{legend.text.size}{Font size for legend (Default: 16)}

\item{plot.text.size}{Font size counts within plot (Default: 3)}

\item{line.width}{Line thickness of title box'}

\item{x.hjust}{Horizontal justification of x axis labels (Default: 1)}

\item{legend.position}{The position of the legend (Default: right)}

\item{x.labels}{X-axis labels (Default: NULL, column.names of the matrix,
doesn't do anything at the moment)}

\item{legend.key.height}{The height of the legend key, as a "unit" object.
(See \code{\link[grid]{unit}}).}

\item{top.n}{Show the n top ranked variants.  Note that if the nth and n+1th
variants have equal rank, they will not be shown.   (Default: 50)}

\item{min.freq}{i (%) only plot variants with frequency >= i% in at least
one sample (Default: 0, i.e no frequency cutoff)}

\item{min.count}{i (integer) only plot variants with count >= i in at least
one sample (default: 0, i.e no count cutoff)}

\item{type}{Plot either "counts" or "proportions"}

\item{order}{A list of column names or indices specifying the order of the
columns in the plot}

\item{alleles}{A list of alleles to include.  Can be used to display
only alleles of interest or to order the alleles.
The default value NULL means all alleles passing the frequency cut offs 
will be included.}
}
\value{
The ggplot2 plot of the variant frequencies
}
\description{
Creates a heatmap from a matrix of counts or proportions,
where tiles are coloured by the proportion and labeled with the value.
}
\examples{
#Load a CrisprSet object for plotting
data("gol_clutch1")

# Plot the frequency heatmap
plotFreqHeatmap(gol)
}
