% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlignments.R
\name{plotAlignments}
\alias{plotAlignments}
\alias{plotAlignments,CrisprSet-method}
\alias{plotAlignments,character-method}
\alias{plotAlignments,DNAString-method}
\title{Plot alignments with respect to a reference sequence}
\usage{
plotAlignments(obj, ...)

\S4method{plotAlignments}{CrisprSet}(
  obj,
  ...,
  min.freq = 0,
  min.count = 1,
  top.n = 50,
  renumbered = obj$pars[["renumbered"]],
  add.other = TRUE,
  create.plot = TRUE
)

\S4method{plotAlignments}{character}(
  obj,
  ...,
  alns,
  ins.sites,
  highlight.pam = TRUE,
  show.plot = FALSE,
  target.loc = 17,
  pam.start = NA,
  pam.end = NA,
  ins.size = 2,
  legend.cols = 3,
  xlab = NULL,
  xtick.labs = NULL,
  xtick.breaks = NULL,
  plot.text.size = 2,
  axis.text.size = 8,
  legend.text.size = 6,
  highlight.guide = TRUE,
  guide.loc = NULL,
  tile.height = 0.55,
  max.insertion.size = 20,
  min.insertion.freq = 5,
  line.weight = 1,
  legend.symbol.size = ins.size,
  add.other = FALSE,
  codon.frame = NULL,
  style = c("all", "mismatches")
)

\S4method{plotAlignments}{DNAString}(
  obj,
  ...,
  alns,
  ins.sites,
  highlight.pam = TRUE,
  show.plot = FALSE,
  target.loc = 17,
  pam.start = NA,
  pam.end = NA,
  ins.size = 2,
  legend.cols = 3,
  xlab = NULL,
  xtick.labs = NULL,
  xtick.breaks = NULL,
  plot.text.size = 2,
  axis.text.size = 8,
  legend.text.size = 6,
  highlight.guide = TRUE,
  guide.loc = NULL,
  tile.height = 0.55,
  max.insertion.size = 20,
  min.insertion.freq = 5,
  line.weight = 1,
  legend.symbol.size = ins.size,
  add.other = FALSE,
  codon.frame = NULL
)
}
\arguments{
\item{obj}{The object to be plotted}

\item{...}{Additional arguments}

\item{min.freq}{i (%) only plot variants with frequency >= i% in at least
one sample (default: 0, i.e no frequency cutoff)}

\item{min.count}{i (integer) only plot variants with count >= i in at least
one sample (default: 0, i.e no count cutoff)}

\item{top.n}{(integer) Plot only the n most frequent variants
(default: 50)}

\item{renumbered}{If TRUE, the x-axis is numbered with respect to the target
(default: TRUE)}

\item{add.other}{Add a blank row labelled "Other" to the plot, for combining
with plotFreqHeatmap (default: TRUE (signature "CrisprSet") FALSE (signature "matrix"))}

\item{create.plot}{Should the data be plotted?  If false, returns the data used
for plotting (Default: TRUE)}

\item{alns}{A named character vector of aligned sequences, with insertions removed}

\item{ins.sites}{A table of insertion_sites, which must include cols
named "start", "cigar", "seq" and "count" for the start of the insertion in the
corresponding sequence}

\item{highlight.pam}{should location of PAM with respect to the target site be
indicated by a box? (Default: TRUE)  If TRUE, and pam.start and pam.end are not
supplied, PAM is inferred from target.loc}

\item{show.plot}{Should the plot be displayed (TRUE) or just returned as
a ggplot object (FALSE).  (Default: FALSE)}

\item{target.loc}{The location of the zero point / cleavage location.  Base n, where
the zero point is between bases n and n+1}

\item{pam.start}{The first location of the PAM with respect to the reference.}

\item{pam.end}{The last location of the PAM with respect to the reference.
Default is two bases after the pam.start}

\item{ins.size}{The size of the symbols representing insertions within the plot.}

\item{legend.cols}{The number of columns in the legend.  (Default:3)}

\item{xlab}{A title for the x-axis (Default: NULL)}

\item{xtick.labs}{Labels for the x-axis ticks (Default: NULL)}

\item{xtick.breaks}{Locations for x-axis tick breaks (Default: NULL)}

\item{plot.text.size}{The size of the text inside the plot}

\item{axis.text.size}{The size of the axis labels}

\item{legend.text.size}{The size of the legend labels}

\item{highlight.guide}{Should the guide be indicated by a box in
the reference sequence?  (Default: TRUE)}

\item{guide.loc}{The location of the guide region to be highlighted,
as an IRanges object. Will be inferred from target.loc if
highlight.guide = TRUE and no guide.loc is supplied, assuming the guide
plus PAM is 23bp (Default: NULL)}

\item{tile.height}{The height of the tiles within the plot. (Default: 0.55)}

\item{max.insertion.size}{The maximum length of an insertion to be shown in the
legend.  If max.insertion.size = n, an insertion of length m > n will
be annotated as "mI" in the figure.  (Default: 20)}

\item{min.insertion.freq}{Display inserted sequences with frequency at least x
amongst the sequences with an insertion of this size and length (Default: 5)}

\item{line.weight}{The line thickness for the vertical line indicating the
zero point (cleavage site) and the boxes for the guide and PAM.  (Default: 1)}

\item{legend.symbol.size}{The size of the symbols indicating insertions
in the legend.  (Default: ins.size)}

\item{codon.frame}{Codon position of the leftmost nucleotide.  If provided,
codon positions in the specified frame are indicated. (Default: NULL)}

\item{style}{One of "all" (colour all tiles) and "mismatches" (colour
only mismatch positions)}
}
\value{
A ggplot2 figure
}
\description{
(signature("CrisprSet")) Wrapper for CrisprSet$plotVariants.
Optionally filters a CrisprSet frequency table, then plots variants.
More information in \code{\link[CrispRVariants]{CrisprSet}}

(signature("DNAString"))  Plots a set of pairwise alignments to a reference sequence.
Alignments should all be the same length as the reference sequences.
This is achieved by removing insertions with respect to the reference,
see \code{\link[CrispRVariants]{seqsToAln}}.
Insertions are indicated by symbols in the plot and a table showing the
inserted sequences below the plot.  The default options are intended for a
figure 6-8 inches wide, with figure height best chosen according to the number
of different variants and insertions to be displayed.
}
\examples{
#Load a CrisprSet object and plot
data("gol_clutch1")
plotAlignments(gol)
}
\seealso{
\code{\link{seqsToAln}}, \code{\link[ggplot2]{ggplot}}
}
\author{
Helen Lindsay
}
