% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alleleLabels.R
\name{mismatchLabels}
\alias{mismatchLabels}
\title{nonindelLabels}
\usage{
mismatchLabels(
  alns,
  target,
  ref.seq,
  regions = NULL,
  min.pct = 0,
  mismatch.label = "SNV",
  genome.to.pos = NULL,
  as.string = TRUE
)
}
\arguments{
\item{alns}{A GAlignments object, where the aligned sequences should span the
reference sequence}

\item{target}{(GRanges(1)) The region for counting mismatches}

\item{ref.seq}{A DNAString object, the sequence for comparison when checking
for mismatches.  The sequence does not necessarily have to match the mapping
reference sequence.  Must span all regions if regions are provided.}

\item{regions}{A GRanges object, regions to check for mismatches with coordinates
relative to the reference sequence}

\item{min.pct}{(numeric(1), between 0 and 100) Only return SNVs that occur
at in least min.pct % of reads.  This tests the occurrence of the exact base
change, not any change at a position.}

\item{mismatch.label}{(character(1)) Label to append to the start of mismatch
strings, if returning as a single string (Default: "SNV:")}

\item{genome.to.pos}{Optional named vector for transforming 
variant coordinates into another coordinate system (Default: NULL)}

\item{as.string}{Should individual variant labels be pasted into
a single comma separated string when one alignment has multiple variants?
(Default: TRUE)}
}
\value{
A data frame of sequence indices, genomic position of mismatch
and mismatch base
}
\description{
Make variant labels for variants without an insertion or deletion
}
