% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findChimeras.R
\name{findChimeras}
\alias{findChimeras}
\title{Find chimeric reads}
\usage{
findChimeras(bam, by.flag = FALSE)
}
\arguments{
\item{bam}{A GAlignments object, must include names}

\item{by.flag}{Can the chimeras be detected just using the supplementary
alignment flag?  (Default: FALSE).  If TRUE, detects supplementary alignments
and returns reads with the same name as a supplementary alignment (quicker).
If FALSE, all alignments with duplicated names are returned.}
}
\value{
A vector of indices of chimeric sequences within the original bam
}
\description{
Find chimeric reads, assuming that the GAlignments object
does not contain multimapping reads. That is, read names that appear
more than ones in the file are considered chimeras.  Chimeric reads
are reads that cannot be mapped as a single, linear alignment.  Reads
from structual rearrangements such as inversions can be mapped as chimeras.
Note that the indices of all chimeric reads are returned, these are not
separated into individual chimeric sets.
}
\examples{
bam_fname <- system.file("extdata", "gol_F1_clutch_2_embryo_4_s.bam",
                         package = "CrispRVariants")
bam <- GenomicAlignments::readGAlignments(bam_fname, use.names = TRUE)
chimera_indices <- findChimeras(bam)
chimeras <- bam[chimera_indices]
}
\seealso{
\code{\link{plotChimeras}} for plotting chimeric alignment sets.
}
\author{
Helen Lindsay
}
