% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTable-class.R, R/LongTable-accessors.R,
%   R/LongTable-utils.R, R/methods-dim.R, R/methods-dimnames.R
\docType{class}
\name{LongTable-class}
\alias{LongTable-class}
\alias{.LongTable}
\alias{rowIDs,LongTable-method}
\alias{rowMeta,LongTable-method}
\alias{colIDs,LongTable-method}
\alias{colMeta,LongTable-method}
\alias{idCols,LongTable-method}
\alias{assayIndex,LongTable-method}
\alias{assayKeys,LongTable-method}
\alias{assayCols,LongTable-method}
\alias{getIntern,LongTable,character-method}
\alias{getIntern,LongTable,missing-method}
\alias{rowData,LongTable-method}
\alias{rowData<-,LongTable-method}
\alias{colData,LongTable-method}
\alias{colData<-,LongTable,ANY-method}
\alias{assays,LongTable-method}
\alias{assays<-,LongTable,list-method}
\alias{assay,LongTable,ANY-method}
\alias{assay<-,LongTable,ANY-method}
\alias{assayNames,LongTable-method}
\alias{names,LongTable-method}
\alias{names}
\alias{[[,LongTable,ANY,ANY-method}
\alias{dim,LongTable-method}
\alias{colnames,LongTable-method}
\alias{rownames,LongTable-method}
\alias{dimnames,LongTable-method}
\title{LongTable class definition}
\usage{
\S4method{rowIDs}{LongTable}(object, data = FALSE, key = FALSE)

\S4method{rowMeta}{LongTable}(object, data = FALSE, key = FALSE)

\S4method{colIDs}{LongTable}(object, data = FALSE, key = FALSE)

\S4method{colMeta}{LongTable}(object, data = FALSE, key = FALSE)

\S4method{idCols}{LongTable}(object)

\S4method{assayIndex}{LongTable}(x)

\S4method{assayKeys}{LongTable}(x, i)

\S4method{assayCols}{LongTable}(object, i)

\S4method{getIntern}{LongTable,character}(object, x)

\S4method{getIntern}{LongTable,missing}(object, x)

\S4method{rowData}{LongTable}(x, key = FALSE, use.names = FALSE, ...)

\S4method{rowData}{LongTable}(x, ...) <- value

\S4method{colData}{LongTable}(x, key = FALSE, dimnames = FALSE, ...)

\S4method{colData}{LongTable,ANY}(x, ...) <- value

\S4method{assays}{LongTable}(
  x,
  withDimnames = TRUE,
  metadata = withDimnames,
  key = !withDimnames,
  ...
)

\S4method{assays}{LongTable,list}(x, withDimnames = TRUE, ...) <- value

\S4method{assay}{LongTable,ANY}(
  x,
  i,
  withDimnames = TRUE,
  summarize = withDimnames,
  metadata = !summarize,
  key = !(summarize || withDimnames),
  ...
)

\S4method{assay}{LongTable,ANY}(x, i) <- value

\S4method{assayNames}{LongTable}(x)

\S4method{[[}{LongTable,ANY,ANY}(x, i)

\S4method{dim}{LongTable}(x)

\S4method{colnames}{LongTable}(x)

\S4method{rownames}{LongTable}(x)

\S4method{dimnames}{LongTable}(x)
}
\arguments{
\item{object}{\code{LongTable}}

\item{data}{\code{logical} Should the colData for the metadata columns be returned
instead of the column names? Default is FALSE.}

\item{key}{\code{logical} Should the key columns also be returned? Defaults to
!withDimnames. This is incompatible with \code{summarize=TRUE}, which will
drop the key columns regardless of the value of this argument.}

\item{x}{The \code{LongTable} object to retrieve the dimnames for.}

\item{i}{\code{character(1)} name or \code{integer} index of the desired assay.}

\item{use.names}{\code{logical} This parameter is just here to stop matching
the positional argument to use.names from the rowData generic. It
doesn't do anything at this time and can be ignored.}

\item{...}{For developer use only! Pass raw=TRUE to return the slot for
modification by reference.}

\item{value}{A \code{data.frame} or \code{data.table} to update the assay data
with. This must at minumum contain the row and column data identifier
columns to allow correctly mapping the assay keys. We recommend modifying
the results returned by assay(longTable, 'assayName', withDimnames=TRUE).
For convenience, both the \code{[[} and \code{$} LongTable accessors return an assay
with the dimnames.}

\item{withDimnames}{\code{logical(1)} Should the dimension names be returned
joined to the assay. This retrieves both the row and column identifiers
and returns them joined to the assay. For}

\item{metadata}{\code{logical(1)} Should all of the metadata also be joined to
the assay. This is useful when modifying assays as the resulting list
has all the information needed to recreated the LongTable object. Defaults
to \code{withDimnames}.}

\item{summarize}{\code{logical(1)} If the assays is a summary where some of
\code{idCols(x)} are not in \code{assayKeys(x, i)}, then those missing columns
are dropped. Defaults to \code{FALSE}. When \code{metadata} is \code{TRUE}, only
metadata columns with 1:1 cardinality with the assay keys for \code{i}.}

\item{`x`}{A \code{LongTable} or inheriting class.}

\item{`i`}{An optional valid assay name or index in \code{x}.}
}
\value{
\code{LongTable} object containing the assay data from a treatment
response experiment

A \code{character} vector of rowData column names if data is FALSE,
otherwise a \code{data.table} with the data from the rowData id columns.

A \code{character} vector of rowData column names if data is FALSE,
otherwise a \code{data.table} with the data from the rowData metadta columns.

A \code{character} vector of colData column names if data is FALSE,
otherwise a \code{data.table} with the data from the colData id columns.

A \code{character} vector of colData column names if data is FALSE,
otherwise a \code{data.table} with the data from the colData metadta columns.

\code{character} A character vector containing the unique rowIDs and
colIDs in a LongTable object.

A \code{mutable} copy of the "assayIndex" for \code{x}

A \code{mutable} copy of the "assyKeys" for \code{x}

A \code{list} of \code{character} vectors containing the value column names for
each assay if i is missing, otherwise a \code{character} vector of value column
names for the selected assay.

\code{immutable} value of x if length(x) == 1 else named list of values
for all symbols in x.

An \code{immutable} list.

A \code{data.table} containing rowID, row identifiers, and row metadata.

A copy of the \code{LongTable} object with the \code{rowData}
slot updated.

A \code{data.table} containing row identifiers and metadata.

A copy of the \code{LongTable} object with the \code{colData}
slot updated.

A \code{list} of \code{data.table} objects, one per assay in the object.

A copy of the \code{LongTable} with the assays modified.

\code{LongTable} With updated assays slot.

\code{character} Names of the assays contained in the \code{LongTable}.

\code{numeric} Vector of object dimensions.

\code{character} Vector of column names.

\code{character} Vector of row names.

\code{list} List with two character vectors, one for row and one for
column names.
}
\description{
Define a private constructor method to be used to build a
\code{LongTable} object.

This is used as an alternative to R attributes for storing structural
metadata of an S4 objects.

Add or replace an assay in a LongTable by name. Currently
this function only works when the assay has all columns in row and column
data tables (i.e., when assays is retured withDimnames=TRUE).

Select an assay from within a LongTable object.
}
\section{Methods (by generic)}{
\itemize{
\item \code{rowMeta(LongTable)}: Get the names of the non-id columns from rowData.

\item \code{colIDs(LongTable)}: Get the names of the columns in colData required to
uniquely identify each row.

\item \code{colMeta(LongTable)}: Get the names of the non-id columns in the colData
\code{data.table}.

\item \code{idCols(LongTable)}: Get the names of all id columns.

\item \code{assayIndex(LongTable)}: Get the assayIndex item from the objects internal metadata.

\item \code{assayKeys(LongTable)}: Get the assayKeys item from the objects internal metadata.

\item \code{assayCols(LongTable)}: Get a list of column names for each assay in the object.

\item \code{getIntern(object = LongTable, x = character)}: Access structural metadata present within a
LongTable object. This is mostly for developmer use.

\item \code{getIntern(object = LongTable, x = missing)}: Access all structural metadata present within a
LongTable object. This is primarily for developmer use.

\item \code{rowData(LongTable)}: Get the row level annotations for a \code{LongTable} object.

\item \code{rowData(LongTable) <- value}: Update the row annotations for a \code{LongTable} object.
Currently requires that all columns in rowIDs(longTable) be present in
value.

\item \code{colData(LongTable)}: Get the column level annotations for a LongTable
object.

\item \code{colData(x = LongTable) <- value}: Update the colData of a LongTable object. Currently
requires that all of the colIDs(longTable) be in the value object.

\item \code{assays(LongTable)}: Get a list containing all the assays in a \code{LongTable}.

\item \code{assays(x = LongTable) <- value}: Update the assays in a LongTable object. The rowIDs
and colIDs must be present in all assays to allow successfully remapping
the keys. We recommend modifying the list returned by
assays(longTable, withDimnames=TRUE) and the reassigning to the
\code{LongTable}.

\item \code{assay(x = LongTable, i = ANY)}: Retrieve an assay \code{data.table} object from the
\code{assays} slot of a \code{LongTable} object.

\item \code{assay(x = LongTable, i = ANY) <- value}: 

\item \code{assayNames(LongTable)}: Return the names of the assays contained in a
\code{LongTable}

\item \code{x[[i}: Get an assay from a LongTable object. This method
returns the row and column annotations by default to make assignment
and aggregate operations easiers.

\item \code{dim(LongTable)}: Get the number of row annotations by the number of
column annotations from a LongTable object. Please note that row x columns
does not necessarily equal the number of rows in an assay, since it is
not required for each assay to have every row or column present.

\item \code{colnames(LongTable)}: Retrieve the pseudo-colnames of a LongTable object,
these are constructed by pasting together the colIDs(longTable) and
can be used in the subset method for regex based queries.

\item \code{rownames(LongTable)}: Retrieve the pseudo-rownames of a LongTable object,
these are constructed by pasting together the rowIDs(longTable) and
can be used in the subset method for regex based queries.

\item \code{dimnames(LongTable)}: Get the pseudo-dimnames for a LongTable object. See
colnames and rownames for more information.

}}
\section{Slots}{

\describe{
\item{\code{rowData}}{See Slots section.}

\item{\code{colData}}{See Slots section.}

\item{\code{assays}}{See Slots section.}

\item{\code{metadata}}{See Slots section.}

\item{\code{.intern}}{See Slots section.}
}}

\section{Slots}{

\itemize{
\item \emph{rowData}: A \code{data.table} containing the metadata associated with the
row dimension of a \code{LongTable}.
\item \emph{colData}: A \code{data.table} containing the metadata associated with the
column dimension of a \code{LongTable}.
\item \emph{assays}: A \code{list} of \code{data.table}s, one for each assay in a
\code{LongTable}.
\item \emph{metadata}: An optional \code{list} of additional metadata for a \code{LongTable}
which doesn't map to one of the dimensions.
\item \emph{.intern}: An \code{immutable} \code{list} that holds internal structural metadata
about a LongTable object, such as which columns are required to key
the object.
}
}

\examples{
rowIDs(merckLongTable)

rowMeta(merckLongTable)

colIDs(merckLongTable)

colMeta(merckLongTable)

idCols(merckLongTable)

assayIndex(nci_TRE_small)

assayKeys(nci_TRE_small)
assayKeys(nci_TRE_small, "sensitivity")
assayKeys(nci_TRE_small, 1)

assayCols(merckLongTable)

getIntern(merckLongTable, 'rowIDs')
getIntern(merckLongTable, c('colIDs', 'colMeta'))

getIntern(merckLongTable)

rowData(merckLongTable)

rowData(merckLongTable) <- rowData(merckLongTable)

colData(merckLongTable)

# Get the keys as well, mostly for internal use
colData(merckLongTable, key=TRUE)

colData(merckLongTable) <- colData(merckLongTable)

assays(merckLongTable)

assays(merckLongTable) <- assays(merckLongTable, withDimnames=TRUE)

# Default annotations, just the key columns
assay(merckLongTable, 'sensitivity')
assay(merckLongTable, 1)

# With identifiers joined
assay(merckLongTable, 'sensitivity', withDimnames=TRUE)

# With identifiers and metadata
assay(merckLongTable, 'profiles', withDimnames=TRUE, metadata=TRUE)

assay(merckLongTable, 'sensitivity') <-
     assay(merckLongTable, 'sensitivity', withDimnames=TRUE)
assay(merckLongTable, 'sensitivity') <- merckLongTable$sensitivity

assayNames(merckLongTable)
names(merckLongTable)

merckLongTable[['sensitivity']]

dim(merckLongTable)

dim(merckLongTable)

head(colnames(merckLongTable))

head(rownames(merckLongTable))

lapply(dimnames(merckLongTable), head)

}
\concept{LongTable-accessors}
\concept{LongTable-class}
\keyword{internal}
