% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizMethods.R
\name{HeatmapFeatures}
\alias{HeatmapFeatures}
\alias{HeatmapFeatures.SingleCellExperiment}
\alias{HeatmapFeatures,SingleCellExperiment-method}
\title{Heatmap visualization of the expression of features by clusters}
\usage{
HeatmapFeatures.SingleCellExperiment(
  object,
  clustering.label,
  features,
  use.color,
  seed.color,
  ...
)

\S4method{HeatmapFeatures}{SingleCellExperiment}(
  object,
  clustering.label,
  features,
  use.color = NULL,
  seed.color = 123,
  ...
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.label}{A variable name (of class \code{character}) available
in the cell metadata \code{colData(object)} with the clustering labels
(\code{character} or \code{factor}) to use.}

\item{features}{Feature names to plot by cluster (\code{character}) matching
\code{row.names(object)}.}

\item{use.color}{Character specifying the colors for the clusters. By default
\code{NULL}, i.e., colors are randomly chosen based on the seed given at
\code{seed.color}. It is overwritten in case the argument \code{annotation_colors}
is provided.}

\item{seed.color}{Seed to randomly select colors for the clusters. By default
\code{123}. It is overwritten in case the argument \code{annotation_colors}
is provided.}

\item{...}{Parameters to pass to \code{pheatmap::pheatmap} function.}
}
\value{
nothing
}
\description{
The \code{HeatmapFeatures} function draws a heatmap of features
by cluster identity.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Plot features by clustering, i.e., grouping variable
# without scaling rows (using 'logcounts' expression):
HeatmapFeatures(
    object = sce, clustering.label = "Species",
    features = row.names(sce)[1:4]
)

# scaling rows:
HeatmapFeatures(
    object = sce, clustering.label = "Species",
    features = row.names(sce)[1:4], scale = "row"
) # scale

}
\keyword{feature}
\keyword{grouped}
\keyword{heatmap}
