% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellStateMethods.R
\name{CellBinsFeatureCorrelation}
\alias{CellBinsFeatureCorrelation}
\alias{CellBinsFeatureCorrelation.SingleCellExperiment}
\alias{CellBinsFeatureCorrelation,SingleCellExperiment-method}
\title{Cell bins feature correlation}
\usage{
CellBinsFeatureCorrelation.SingleCellExperiment(object, labels, method)

\S4method{CellBinsFeatureCorrelation}{SingleCellExperiment}(object, labels = NULL, method = "pearson")
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class obtained with the
function \code{BinCellClusterProbability()}.}

\item{labels}{Character of label(s) from the label provided to the function
\code{BinCellClusterProbability()}. By default \code{NULL}, i.e., all labels
are used.}

\item{method}{Character specifying the correlation method to use. One of
\code{"pearson"}, \code{"kendall"} or \code{"spearman"}. By default \code{"pearson"}
is used.}
}
\value{
A data frame with the correlation coefficient for each feature (rows)
across labels (columns).
}
\description{
Correlation between cell bins for the given labels and features.
}
\examples{
\donttest{
# Packages
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Import data from Zenodo
data.url <- "https://zenodo.org/records/14845751/files/pbmc_10Xassays.rds?download=1"
sce <- readRDS(file = url(data.url))

# Prepare data
sce <- PrepareData(object = sce)

# Multi-level integration - 'L = 4' just for highlighting purposes
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "batch", L = 4,
    threads = 2
)

# Cell states SCE object for a given cell type annotation or clustering
cellstate.sce <- BinCellClusterProbability(
    object = sce, label = "cell_type",
    icp.round = 4, bins = 20
)
cellstate.sce

# Pearson correlated features with "Monocyte"
cor.features.mono <- CellBinsFeatureCorrelation(
    object = cellstate.sce,
    labels = "Monocyte"
)
}

}
\keyword{Cell}
\keyword{bins}
\keyword{correlation}
\keyword{feature}
