% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsPennCNV.R
\name{loadCopyNumberCallspennCNV}
\alias{loadCopyNumberCallspennCNV}
\title{loadCopyNumberCallspennCNV}
\usage{
loadCopyNumberCallspennCNV (pennCNV.file, chr.col = NULL, start.col = NULL, end.col = NULL, cn.col = NULL, segment.value.col = NULL, genome = NULL, verbose=TRUE)
}
\arguments{
\item{pennCNV.file}{The name of the file with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to NULL)}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NULL)}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to NULL)}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment or a list of GRanges with a GRanges per sample.
}
\description{
Loads copy number calls from pennCNV.rawcnv file format
}
\details{
This function will load copy number calls from pennCNV.rawcnv file format. 
Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files. 
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
## loadCopyNumberCallspennCNV from .rawcnv file format: 
## The file to run the example can be found in: http://penncnv.openbioinformatics.org/en/latest/user-guide/test/

pennCNV.file <- system.file("extdata", "pennCNV.rawcnv", package = "CopyNumberPlots", mustWork = TRUE)
cnv.call <- loadCopyNumberCallspennCNV(pennCNV.file = pennCNV.file)

}
