% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getSegmentValueColumn}
\alias{getSegmentValueColumn}
\title{getSegmentValueColumn}
\usage{
getSegmentValueColumn(df, col = NULL, avoid.pattern = NULL, needed = TRUE, verbose = TRUE)
}
\arguments{
\item{df}{(data.frame or equivalent) The object were columns are searched. It must be either a data.frame or an object where names(df) works.}

\item{col}{(number or character) The column to identify. If NULL an heuristic will be used to automatically identify the column. It can also a number or a character to define the exact column to return.(defaults to NULL)}

\item{avoid.pattern}{(character) An optional pattern to avoid on the column name. The pattern may be any valid regular expression. (defaults to "")}

\item{needed}{(logical) Whether the column is needed or not. If TRUE, an error will be raised if the column is not found. (defaults to TRUE)}

\item{verbose}{Whether to show information messages. (defaults to TRUE)}
}
\value{
The number of the column matching the specification or NULL if no column was found.
}
\description{
Identify the column in a data.frame or equivalent with the position of
the segment value information.
}
\details{
Identify the column of a data.frame or equivalent that contains the segment
information and return its position.
}
\examples{

df <- data.frame("id"= "rs1234","chromosome"="chr1", "Start"=0, "end.position"=100,
"copy.number.level"=3, "LOH"=0, "median.value.per.segment"=1.2,
"BAF"=0.2, "Log Ratio"=1.5, "strange.name"="strange.value")
col.num <- getSegmentValueColumn(df = df)
col.num <- getSegmentValueColumn(df = df, col = "median.value.per.segment")

}
