% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCopyNumberColors.R
\name{getCopyNumberColors}
\alias{getCopyNumberColors}
\title{getCopyNumberColors}
\usage{
getCopyNumberColors(colors=NULL)
}
\arguments{
\item{colors}{(character) Either a palette name (i.e. "green_orange_red") or a vector of colors. If NULL the default palette ("green_orange_red") will be returned. (defaults to NULL)}
}
\value{
A vector of colors with the names set to the positions in the vector.
}
\description{
Get the colors representing the copy number levels
}
\details{
This function returns a vector of colors with names from 0 to the length
of the vector. The colors will be used to represent copy numbers from
0 (homozygous deletion) to the copy number equal to the length of  the
vector (typically 7 or 8). The function has a single parameter `colors`,
which can be either the name of one of the available palettes or the
a vector of valid color specifications (i.e. c("red", "#FFAAAA", "gray",
"#AAAAFF", "#5555FF", "#0000FF")).  If `colors` is a palette name,
the palette will be returned. If color is a color vector, it will be returned
with the names set as needed.

Available palettes are: "gree_orange_red" and "red_blue"
}
\examples{

getCopyNumberColors()

getCopyNumberColors("red_blue")

getCopyNumberColors(c("red", "#FFAAAA", "gray", "#AAAAFF", "#5555FF", "#0000FF"))

}
