% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{computeHclustPlotOrder}
\alias{computeHclustPlotOrder}
\title{computeHclustPlotOrder}
\usage{
computeHclustPlotOrder(m)
}
\arguments{
\item{m}{(matrix) A merge matrix with 2 columns representing the merges
bewteen elements and clusters. The format is described in the documentation
of hclust.}
}
\value{
A vector with the ordering of the nodes.
}
\description{
Given the merge matrix of an hclust object, compute a valid ordering of 
the samples so a dendogram can be plotted with no line crossings. 

Note: It's been implemented from scratch but in our experience reproduces
exactly the ordering produced by R own ordering algorithm used by hclust.
}
\examples{

ztree <- matrix(c(0,3,0.1,2,
                  1,4,0.2,2,
                  5,2,0.3,2,
                  6,7,0.4,2),
                  nrow=4)
                
 hc.tree <- Ztree2Hclust(ztree)
 plot(hc.tree)
 
 #Set the ordering to a non-correct ordering
 hc.tree$order <- c(1:5)
 
 #When we plot, we see line crossings
 plot(hc.tree)
 
 #Compute a correct ordering and replot
 element.order <- computeHclustPlotOrder(hc.tree$merge)
 hc.tree$order <- element.order
 plot(hc.tree)

}
