% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitModLab.R
\name{splitModLab}
\alias{splitModLab}
\title{Split Modification and Label tags}
\usage{
splitModLab(.data)
}
\arguments{
\item{.data}{dataframe}
}
\value{
dataframe
}
\description{
Splits up the Modifications column into lists of vectors for 
modifications(Mods) and labels(Labels)
It adds two more columns to the data frame:
\itemize{
\item UniqueCombinedID_A: Unique combinations of Sequence, Mods and Charge 
for "scenario A".
\item UniqueCombinedID_B: Unique combinations of Sequence, Mods, Charge and 
Labels for "scenario B"
}
}
\examples{
##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 

}
