% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNormTable.R
\name{getNormTable}
\alias{getNormTable}
\title{Get normalised table for all proteins}
\usage{
getNormTable(.listDf, purpose = "analysis")
}
\arguments{
\item{.listDf}{list of data frames}

\item{purpose}{character, purpose of use of function output, values either
"analysis" of "export"}
}
\value{
dataframe
}
\description{
Extracts values for representative peptides for each protein, 
for both scenario A and scenario B.
Results are combined into one data frame in a format either indended for
further analysis or for export.
}
\examples{

##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 
## remove unneccessary columns, simplify rows
peptides <- simplifyProteins(peptides) 
## Pick representative peptide for each protein for both scenarios
peptide_index <- pickPeptide(peptides)
## extract table with normalised protein values for both scenarios
forAnalysis <- getNormTable(peptide_index,purpose = "analysis")

}
