% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Methods.R
\name{cluster2data}
\alias{cluster2data}
\alias{cluster2data,ClustAllObject,character-method}
\title{Export Stratification Results with Original Data}
\usage{
cluster2data(Object, stratificationName)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object.
The object must have been processed by \code{\link{runClustAll}} before using
this function.}

\item{stratificationName}{A character vector specifying the names of one or more
stratifications to be exported. These names should correspond to stratifications
generated by the ClustALL algorithm and stored in the Object.}
}
\value{
A data.frame that includes the original data with additional column(s)
containing the selected stratification(s). Each selected stratification will
be added as a separate column to the original dataset.
}
\description{
This function combines the original input data with one or more selected
stratifications from the ClustALL algorithm results. It allows users to
examine how samples are clustered in the context of their original features,
facilitating further analysis and interpretation of the stratification
results.
}
\details{
The cluster2data function serves some important purposes in the ClustALL workflow:

1. Data Integration: It combines clustering results with the original feature data,
   allowing for comprehensive analysis of how cluster assignments relate to
   input variables.

2. Preparation for External Analysis: The resulting data frame can be easily
   exported for use in other analytical tools or visualization software.

The function is particularly useful for:
\itemize{
  \item Identifying features that distinguish different clusters
  \item Comparing how samples are grouped across different stratifications
  \item Preparing data for cluster-specific statistical analyses
  \item Creating visualizations that incorporate both cluster assignments and original features
}
}
\note{
\itemize{
  \item This function requires a processed ClustAllObject. Ensure \code{\link{runClustAll}}
    has been executed before using cluster2data.
  \item The stratificationName parameter accepts multiple stratification names, allowing
    for simultaneous export of multiple clustering solutions.
  \item Stratification names can be obtained from the results of \code{\link{resStratification}}
    or by examining the names in the summary_clusters slot of the ClustAllObject.
  \item The original data in the returned data frame includes all preprocessing steps
    applied during the creation of the ClustAllObject, such as one-hot encoding
    of categorical variables.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
obj_noNA <- createClustAll(data = wdbc)
\donttest{
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = TRUE)
resStratification(Object = obj_noNA1, population = 0.05,
                  stratification_similarity = 0.88, all = FALSE)
df <- cluster2data(Object = obj_noNA1,
                   stratificationName = c("cuts_a_1","cuts_b_5","cuts_a_5"))
}
}
\seealso{
\code{\link{runClustAll}}, \code{\link{resStratification}},
\code{\link{ClustAllObject-class}}, \code{\link{createClustAll}}
}
