% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_merge.R
\name{mergeTolerance}
\alias{mergeTolerance}
\title{Merge spectra with m/z tolerance}
\usage{
mergeTolerance(x, y, tolerance = 1e-05)
}
\arguments{
\item{x, y}{MS2 spectra as objects of class \code{matrix} with m/z in the
first column and intensity in the second.}

\item{tolerance}{The m/z tolerance used for merging. If two peaks are within
tolerance, they are regarded as the same. Defaults to \code{1e-5}, i.e.
10ppm.}
}
\value{
A matrix with m/z in the first column and separate columns for
    intensities in the respective spectra. If peaks were merged, their m/z
    corresponds to the mean of the two original m/z.
}
\description{
\code{mergeTolerance()} merges two spectra by identifying common peaks with
a given m/z tolerance. It can be used with \code{Reduce()} to merge more
than two spectra.
}
\keyword{internal}
