% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optics.R
\name{OPTICStbl}
\alias{OPTICStbl}
\title{Density-based clustering of spectral similarity data}
\usage{
OPTICStbl(distmat, eps = 10000, minPts = 3, eps_cl = 0.5)
}
\arguments{
\item{distmat}{A distance matrix as generated by
\code{\link{distanceMatrix}}.}

\item{eps, minPts}{OPTICS parameters, see \code{\link[dbscan]{optics}}.}

\item{eps_cl}{The reachability distance used for cluster determination,
see \code{\link[dbscan:optics]{extractDBSCAN}}.}
}
\value{
A \code{data.frame} with feature name, cluster ID and
OPTICS order for each feature in \code{distmat}.
}
\description{
\code{OPTICStbl()} performs density-based clustering
of spectral similarity data using the OPTICS algorithm.
}
\details{
The function internally uses \code{\link[dbscan]{optics}}
and \code{\link[dbscan:optics]{extractDBSCAN}} from the \pkg{dbscan}
package.
}
\examples{
load(file = system.file("extdata",
    "distmat.RData",
    package = "CluMSIDdata"))

my_OTPICStbl <- OPTICStbl(distmat[1:50,1:50], eps_cl = 0.7)

}
\seealso{
OPTICSplot
}
